"""Auto-generated stub file for GTA V ScriptHookVDotNet"""

from typing import Any, List, Dict, Optional, Iterable, ClassVar, Tuple, Callable, TypeVar, overload, Union
from enum import Enum

from GTA import (
    Blip,
    Camera,
    Checkpoint,
    Entity,
    Game,
    Model,
    Ped,
    PedHash,
    Player,
    Prop,
    Vehicle,
    VehicleHash,
    Weapon,
    WeaponHash,
    World
)
from GTA.Math import Matrix, Quaternion, Vector2, Vector3

class GameClock:
    IsPaused: ClassVar[bool]
    LastTimeMinAdded: ClassVar[int]
    Now: ClassVar[GameClockDateTime]
    Today: ClassVar[GameClockDate]
    TimeOfDay: ClassVar[GameClockTime]
    Day: ClassVar[int]
    Month: ClassVar[int]
    Month0: ClassVar[int]
    Year: ClassVar[int]
    DayOfWeek: ClassVar[Any]
    Hour: ClassVar[int]
    Minute: ClassVar[int]
    Second: ClassVar[int]
    MillisecondsPerGameMinute: ClassVar[int]
    @staticmethod
    def AddToCurrentTime(hours: int, minutes: int, seconds: int) -> None: ...

class GameClockDate:
    Year: int
    DayOfYear: int
    DayOfYear0: int
    DayOfWeek: Any
    IsoDayOfWeek: IsoDayOfWeek
    Month: int
    Month0: int
    Day: int
    Day0: int
    IsLeapYear: bool
    MaxValue: ClassVar[GameClockDate]
    MinValue: ClassVar[GameClockDate]
    def AndTime(self, time: GameClockTime) -> GameClockDateTime: ...
    def AndHms(self, hour: int, minute: int, second: int) -> GameClockDateTime: ...
    @staticmethod
    def FromSystemDateTime(dateTime: Any) -> GameClockDate: ...
    @staticmethod
    def FromYmd(year: int, month: int, day: int) -> GameClockDate: ...
    @staticmethod
    def TryFromYmd(year: int, month: int, day: int, date: GameClockDate) -> bool: ...
    @staticmethod
    def FromOrdinalDate(year: int, ordinal: int) -> GameClockDate: ...
    @staticmethod
    def TryFromOrdinalDate(year: int, ordinal: int, date: GameClockDate) -> bool: ...
    @staticmethod
    def FromIsoWeekDate(year: int, week: int, dayOfWeek: IsoDayOfWeek) -> GameClockDate: ...
    @staticmethod
    def TryFromIsoWeekDate(year: int, week: int, dayOfWeek: IsoDayOfWeek, date: GameClockDate) -> bool: ...
    def TryAdd(self, duration: GameClockDuration, date: GameClockDate) -> bool: ...
    def AddMonths(self, months: int) -> GameClockDate: ...
    def TryAddMonths(self, months: int, date: GameClockDate) -> bool: ...
    def TrySubtract(self, duration: GameClockDuration, date: GameClockDate) -> bool: ...
    def SubtractMonths(self, months: int) -> GameClockDate: ...
    def TrySubtractMonths(self, months: int, date: GameClockDate) -> bool: ...
    def WithYear(self, year: int) -> GameClockDate: ...
    def WithMonth(self, month: int) -> GameClockDate: ...
    def WithMonth0(self, month0: int) -> GameClockDate: ...
    def WithDay(self, day: int) -> GameClockDate: ...
    def WithDay0(self, day0: int) -> GameClockDate: ...
    def WithDayOfYear(self, dayOfYear: int) -> GameClockDate: ...
    def WithDayOfYear0(self, dayOfYear0: int) -> GameClockDate: ...
    def SignedDurationSince(self, value: GameClockDate) -> GameClockDuration: ...
    def YearsSince(self, other: GameClockDate) -> int: ...
    def Deconstruct(self, year: int, month: int, day: int) -> None: ...
    @overload
    def Equals(self, value: GameClockDate) -> bool: ...
    @overload
    def Equals(self, value: object) -> bool: ...
    def Equals(self, *args: Any, **kwargs: Any) -> Any: ...
    def ToString(self) -> str: ...
    @overload
    def CompareTo(self, value: object) -> int: ...
    @overload
    def CompareTo(self, value: GameClockDate) -> int: ...
    def CompareTo(self, *args: Any, **kwargs: Any) -> Any: ...
    def GetHashCode(self) -> int: ...

class GameClockDateTime:
    Date: GameClockDate
    Time: GameClockTime
    Year: int
    DayOfYear: int
    DayOfYear0: int
    DayOfWeek: Any
    IsoDayOfWeek: IsoDayOfWeek
    Month: int
    Month0: int
    Day: int
    Day0: int
    Hour: int
    Hour12: Tuple[bool, int]
    Minute: int
    Second: int
    SecondsFromMidnight: int
    MaxValue: ClassVar[GameClockDateTime]
    MinValue: ClassVar[GameClockDateTime]
    def __init__(self, date: GameClockDate, time: GameClockTime) -> None: ...
    def GetHour12(self, hour: int) -> bool: ...
    def WithYear(self, year: int) -> GameClockDateTime: ...
    def WithMonth(self, month: int) -> GameClockDateTime: ...
    def WithMonth0(self, month0: int) -> GameClockDateTime: ...
    def WithDay(self, day: int) -> GameClockDateTime: ...
    def WithDay0(self, day0: int) -> GameClockDateTime: ...
    def WithDayOfYear(self, dayOfYear: int) -> GameClockDateTime: ...
    def WithDayOfYear0(self, dayOfYear0: int) -> GameClockDateTime: ...
    def WithHour(self, hour: int) -> GameClockDateTime: ...
    def WithMinute(self, minute: int) -> GameClockDateTime: ...
    def WithSecond(self, second: int) -> GameClockDateTime: ...
    @staticmethod
    def FromSystemDateTime(dateTime: Any) -> GameClockDateTime: ...
    def TryAdd(self, duration: GameClockDuration, dateTime: GameClockDateTime) -> bool: ...
    def AddMonths(self, months: int) -> GameClockDateTime: ...
    def TryAddMonths(self, months: int, dateTime: GameClockDateTime) -> bool: ...
    def TrySubtract(self, duration: GameClockDuration, dateTime: GameClockDateTime) -> bool: ...
    def SubtractMonths(self, months: int) -> GameClockDateTime: ...
    def TrySubtractMonths(self, months: int, dateTime: GameClockDateTime) -> bool: ...
    def SignedDurationSince(self, value: GameClockDateTime) -> GameClockDuration: ...
    def Deconstruct(self, date: GameClockDate, time: GameClockTime) -> None: ...
    @overload
    def Equals(self, value: GameClockDateTime) -> bool: ...
    @overload
    def Equals(self, value: object) -> bool: ...
    def Equals(self, *args: Any, **kwargs: Any) -> Any: ...
    def ToString(self) -> str: ...
    @overload
    def CompareTo(self, value: object) -> int: ...
    @overload
    def CompareTo(self, value: GameClockDateTime) -> int: ...
    def CompareTo(self, *args: Any, **kwargs: Any) -> Any: ...
    def GetHashCode(self) -> int: ...

class GameClockDuration:
    Hours: int
    Minutes: int
    Seconds: int
    TotalWeeks: float
    TotalDays: float
    TotalHours: float
    TotalMinutes: float
    WholeWeeks: int
    WholeDays: int
    WholeHours: int
    WholeMinutes: int
    WholeSeconds: int
    Zero: ClassVar[GameClockDuration]
    MaxValue: ClassVar[GameClockDuration]
    MinValue: ClassVar[GameClockDuration]
    @overload
    def CompareTo(self, value: object) -> int: ...
    @overload
    def CompareTo(self, value: GameClockDuration) -> int: ...
    def CompareTo(self, *args: Any, **kwargs: Any) -> Any: ...
    @staticmethod
    def FromWeeks(weeks: int) -> GameClockDuration: ...
    @staticmethod
    def FromDays(days: int) -> GameClockDuration: ...
    @staticmethod
    def FromHours(hours: int) -> GameClockDuration: ...
    @staticmethod
    def FromMinutes(minutes: int) -> GameClockDuration: ...
    @staticmethod
    def FromSeconds(seconds: int) -> GameClockDuration: ...
    @staticmethod
    def FromTimeSpan(timeSpan: float) -> GameClockDuration: ...
    def Abs(self) -> GameClockDuration: ...
    @overload
    def Equals(self, value: GameClockDuration) -> bool: ...
    @overload
    def Equals(self, value: object) -> bool: ...
    def Equals(self, *args: Any, **kwargs: Any) -> Any: ...
    def ToString(self) -> str: ...
    def GetHashCode(self) -> int: ...

class GameClockTime:
    Hour: int
    Hour12: Tuple[bool, int]
    Minute: int
    Second: int
    SecondsFromMidnight: int
    MaxValue: ClassVar[GameClockTime]
    MinValue: ClassVar[GameClockTime]
    def GetHour12(self, hour: int) -> bool: ...
    @staticmethod
    def FromHms(hour: int, minute: int, second: int) -> GameClockTime: ...
    @staticmethod
    def FromSecondsFromMidnight(seconds: int) -> GameClockTime: ...
    def WithHour(self, hour: int) -> GameClockTime: ...
    def WithMinute(self, minute: int) -> GameClockTime: ...
    def WithSecond(self, second: int) -> GameClockTime: ...
    def OverflowingAddSigned(self, duration: GameClockDuration, wrappedDays: int) -> GameClockTime: ...
    def OverflowingSubtractSigned(self, duration: GameClockDuration, wrappedDays: int) -> GameClockTime: ...
    def SignedDurationSince(self, value: GameClockTime) -> GameClockDuration: ...
    @overload
    def CompareTo(self, value: object) -> int: ...
    @overload
    def CompareTo(self, value: GameClockTime) -> int: ...
    def CompareTo(self, *args: Any, **kwargs: Any) -> Any: ...
    def ToString(self) -> str: ...
    def Deconstruct(self, hour: int, minute: int, second: int) -> None: ...
    @overload
    def Equals(self, value: GameClockTime) -> bool: ...
    @overload
    def Equals(self, value: object) -> bool: ...
    def Equals(self, *args: Any, **kwargs: Any) -> Any: ...
    def GetHashCode(self) -> int: ...

class InvalidInternalMonthOfGameClockException:
    Month0: int
    Month: int
    def GetObjectData(self, info: Any, context: Any) -> None: ...

class IsoDayOfWeek(Enum):
    Monday = 0
    Tuesday = 1
    Wednesday = 2
    Thursday = 3
    Friday = 4
    Saturday = 5
    Sunday = 6

class YearFlags:
    pass
